import { world, EntityComponentTypes, ItemTypes, ItemStack, system } from '@minecraft/server';
let farmingAddonCompatabilityEnabled = false;
world.afterEvents.worldInitialize.subscribe(() => {
    try {
        farmingAddonCompatabilityEnabled = ItemTypes.get('pod_farm:venison_raw') !== undefined;
    } catch (error) {}
});
const farmingAddonItemCompatability = {
    'sf_nba:venison': 'pod_farm:venison_raw',
    'sf_nba:goose': 'pod_farm:goose_raw',
    'sf_nba:duck': 'pod_farm:duck_raw',
    'sf_nba:cooked_venison': 'pod_farm:venison_cooked',
    'sf_nba:cooked_goose': 'pod_farm:goose_cooked',
    'sf_nba:cooked_egg': 'pod_farm:cooked_egg',
    'sf_nba:cooked_duck': 'pod_farm:duck_cooked',
};
world.afterEvents.entitySpawn.subscribe(async (event) => {
    try {
        if (!farmingAddonCompatabilityEnabled) return;
        const entity = event.entity;
        if (entity.typeId !== 'minecraft:item') return;
        const itemComponent = entity.getComponent(EntityComponentTypes.Item);
        if (!itemComponent) return;
        const newItemType = farmingAddonItemCompatability[itemComponent.itemStack.typeId];
        if (!newItemType) return;
        const itemStack = new ItemStack(newItemType, itemComponent.itemStack.amount);
        const item = entity.dimension.spawnItem(itemStack, entity.location);
        item.applyImpulse(entity.getVelocity());
        entity.remove();
    } catch (error) {}
});
world.afterEvents.worldInitialize.subscribe((event) => {
    try {
        system.runJob(
            (function* () {
                while (true) {
                    try {
                        for (const player of world.getPlayers()) {
                            const inventory = player.getComponent(EntityComponentTypes.Inventory);
                            if (!inventory) continue;
                            const container = inventory.container;
                            if (!container) continue;
                            const size = container.size;
                            for (let slotIndex = 0; slotIndex < size; slotIndex++) {
                                try {
                                    const slot = container.getSlot(slotIndex);
                                    if (!slot || !slot.isValid()) continue;
                                    const slotItemStack = slot.getItem();
                                    if (!slotItemStack) continue;
                                    const newItemType = farmingAddonItemCompatability[slotItemStack.typeId];
                                    if (!newItemType) continue;
                                    const itemStack = new ItemStack(newItemType, slotItemStack.amount);
                                    slot.setItem(itemStack);
                                } catch (slotError) {}
                            }
                        }
                    } catch (playerError) {}
                    yield;
                }
            })()
        );
    } catch (error) {
        console.error('Error initializing world compatibility job:', error);
    }
});